From 1998 to 2003, there were 55 MJO events globally. After regional identification, this period has 46 MJO over the Indo-Pacific region and nine events elsewhere. Over the Indo-Pacific region, 1998-2003 has 38 MJO events that reach the Maritime Continent (MJO centroid reach >= 1 day over the MC), and 8 MJO that not (or not significantly) interacted with the MC.

From 1998 to 2017, there were 215 MJO events globally. After regional identification, this period has 187 MJO events over the Indo-Pacific region (87%) and 28 elsewhere (13%). Over the Indo-Pacific region, 1998-2017 has 156 MJO events that reach the Maritime Continent (95E-150E and 10S-7N) and spend the time over the MC for more than a day (83%). Meanwhile, 31 of them were not or not significantly interacted with the MC (17%).

In 2017, there were 13 MJO events globally. After regional identification, this year has 11 MJO events over the Indo-Pacific region and two events elsewhere. Over the Indo-Pacific region, 10 of them were reached the Maritime Continent, and only one event that was not interacted with the MC.

In 1998, there were 8 MJO events globally: 6 over Indo-Pacific and 2 elsewhere. Over the Indo-Pacific region, 5 of them reached the Maritime Continent and 1 was not significantly interacted with MC.

Setting: if a MJO event reach MC for less than 8 time steps (3-hour for each time step), classify it as 'no' to 'reach_mc' class
Visual observation: non-interacted mjo with mc: detoured or misc (discarded)
1998 = 1 (misc)
1999 = 2 (misc)
2000 = 1 (misc)
2001 = 1 (misc)
2002 = 1 (visually detoured?)
2003 = 2 (misc)
2004 = 4 (misc)
2005 = 1 (misc)
2006 = 1 (misc)
2007 = 0 (misc)
2008 = 1 (misc)
2009 = 2 (misc)
2010 = 1 (misc)
2011 = 1 (misc)
2012 = 3 (misc)
2013 = 2 (misc)
2014 = 1 (misc)
2015 = 5 (misc)
2016 = 0 (misc)
2017 = 1 (misc)

The detoured or misc MJO events are events that not interacted with the MC. Therefore, since this study is concerning land-atmosphere interaction, further analysis will not consider these type of MJO events.

Visual observation: MJO events that interacted with MC (this can be further classified into MJO-B or MJO-C, or MJO deflected?)

year, n_mjo_mc, mjo-c (id), mjo-c-or-b, mjo-b (id),    misc2 (id),   
1998,        5,  3 (4;5;6),          0,    2 (1;2),             0,
1999,        5,      1 (3),          0,    2 (5;6),       2 (2;7), # id 2 propagated westward; id 7 not interact with landmass
2000,        6,  3 (2;3;4),          0,      1 (7),       2 (1;6), # id 1 initiated northern Malay Penin & westward move; id 6 initiated too east
2001,        7,      1 (8),      1 (4),         0 , 5 (0;1;2;5;6), # id 8 mjo-c but ended before 150E; id 1 not interact with landmass; id 6 detoured south; id 2 not interacted with landmass; id 0 not interacted with mc landmass


To classify MJO-C, starting location and ending location seems not enough. I think about momentum (mass x speed), MJO-B might be occurred because a huge momentum drops/loss. If a MJO event still keep have the momentum after interacted with MC, and can get off from MC region, it might be classified as MJO-C. Now, how to translate 'momentum' to the available track information? Each track has time (YYYYMMDDHH), centroid location (lat, lon), and Area of MJO envelope (km2). The firs two information can calculate instantaneous SPEED of MJO center and the last information might represent intensity with certain standardization (e.g., divided by a constant with the same unit (km2) to have a unitless value describing the intensity of MJO track. It is important to have a MJO event that initiated outside the MC in order to see the momentum drops (so that any event that initated over MC will be difficult to analyze regarding its land-atmosphere interaction. 

min_contact_days = 2 seems more accurate to eliminate MJO that not interacted with the Maritime Continent! see 1998-2017_mjo_analysis.xlsx in Google Sheet for more information.




